//
//  table__f_v_a_r.h
//  GSFontTools
//
//  Created by Georg Seifert on 31.08.16.
//  Copyright 2016 schriftgestaltung.de. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import <GSFontTools/TTable.h>
#import <GSFontTools/table__n_a_m_e.h>

@interface GXAxis : NSObject

@property (nonatomic, strong) NSString *axisTag;
@property (nonatomic) GSNameIdNames nameID;
@property (nonatomic) uint16_t flags;		// not exposed in XML because spec defines no values
@property (nonatomic) CGFloat minValue;		// -1.0
@property (nonatomic) CGFloat defaultValue; //  0.0
@property (nonatomic) CGFloat maxValue;		//  1.0

- (instancetype)initWithTag:(NSString *)axisTag min:(CGFloat)minValue default:(CGFloat)defaultValue max:(CGFloat)maxValue;
- (BOOL)decompile:(NSData *)data pos:(NSUInteger *)pos error:(NSError **)error;
- (BOOL)compile:(NSMutableData *)data error:(NSError **)error;
- (void)toXML:(GSXMLWriter *)writer font:(TTFont *)font;

@end

@interface GXNamedInstance : NSObject

@property (nonatomic, strong) NSString *name; // 0
@property (nonatomic) GSNameIdNames nameID;	  // min 256
@property (nonatomic) uint16_t flags;		  // 0  # not exposed in XML because spec defines no values
@property (nonatomic, strong) NSMutableDictionary *coordinates;
@property (nonatomic) GSNameIdNames postscriptNameID;

- (BOOL)decompile:(NSData *)data axisTags:(NSArray *)axisTags error:(NSError **)error;
- (BOOL)compile:(NSMutableData *)data axisTags:(NSArray *)axisTags doPostScriptNameID:(BOOL)doPostScriptNameID error:(NSError **)error;
- (void)toXML:(GSXMLWriter *)writer font:(TTFont *)font;

@end

@interface table__f_v_a_r : TTable

@property (nonatomic) int32_t version; //: L
@property (nonatomic, strong) NSMutableArray<GXAxis *> *axes;
@property (nonatomic, strong) NSMutableArray<GXNamedInstance *> *instances;

- (NSArray *)axisTags;
- (GXAxis *)getAxis:(NSString *)axisTag;

@end
